<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('forum_categories', function (Blueprint $table) {
            $table->json('required_roles')->nullable()->after('is_active');
            $table->json('required_permissions')->nullable()->after('required_roles');
            $table->boolean('is_public')->default(true)->after('required_permissions');
        });

        Schema::table('forum_boards', function (Blueprint $table) {
            $table->json('required_roles')->nullable()->after('is_active');
            $table->json('required_permissions')->nullable()->after('required_roles');
            $table->boolean('is_public')->default(true)->after('required_permissions');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('forum_categories', function (Blueprint $table) {
            $table->dropColumn(['required_roles', 'required_permissions', 'is_public']);
        });

        Schema::table('forum_boards', function (Blueprint $table) {
            $table->dropColumn(['required_roles', 'required_permissions', 'is_public']);
        });
    }
};